/*
 * Decompiled with CFR 0.152.
 */
package jdos.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jdos.Dosbox;
import jdos.gui.Main;
import jdos.util.FileHelper;
import jdos.util.FileIO;
import jdos.util.LRUCache;

public class FileIOFactory {
    public static final int MODE_READ = 1;
    public static final int MODE_WRITE = 2;
    public static final int MODE_TRUNCATE = 4;

    public static boolean isRemote(String path) {
        return path.toLowerCase().startsWith("http://") || path.toLowerCase().startsWith("jar://");
    }

    public static boolean canOpen(String path, int mode) {
        try {
            FileIO f = FileIOFactory.open(path, mode);
            f.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getFullPath(String path) throws FileNotFoundException {
        if (path.toLowerCase().startsWith("http://")) {
            return path.substring(0, path.lastIndexOf(47));
        }
        if (path.toLowerCase().startsWith("jar://")) {
            return path.substring(0, path.lastIndexOf(47));
        }
        return new File(path).getAbsoluteFile().getParentFile().getAbsolutePath();
    }

    public static InputStream openStream(String path) throws FileNotFoundException {
        if (path.toLowerCase().startsWith("http://")) {
            try {
                URL url = new URL(path);
                URLConnection urlConn = url.openConnection();
                urlConn.setDoInput(true);
                urlConn.setUseCaches(true);
                Object b = null;
                long size = 0L;
                InputStream is = urlConn.getInputStream();
                if (path.toLowerCase().endsWith(".zip")) {
                    ZipInputStream zis = new ZipInputStream(is);
                    ZipEntry entry = zis.getNextEntry();
                    is = zis;
                }
                return is;
            }
            catch (Throwable e) {
                throw new FileNotFoundException(path);
            }
        }
        if (path.toLowerCase().startsWith("jar://")) {
            InputStream is = Dosbox.class.getResourceAsStream(path = path.substring(6));
            if (is == null) {
                throw new FileNotFoundException();
            }
            return is;
        }
        path = FileHelper.resolve_path(path);
        return new FileInputStream(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileIO open(String path, int mode) throws FileNotFoundException {
        if (path.toLowerCase().startsWith("http://")) {
            try {
                int read;
                ByteArrayOutputStream os;
                URL url = new URL(path);
                URLConnection urlConn = url.openConnection();
                urlConn.setDoInput(true);
                urlConn.setUseCaches(true);
                byte[] b = null;
                long size = 0L;
                InputStream is = urlConn.getInputStream();
                if (path.toLowerCase().endsWith(".zip")) {
                    ZipInputStream zis = new ZipInputStream(is);
                    ZipEntry entry = zis.getNextEntry();
                    is = zis;
                    os = new MyByteArrayOutputStream((int)entry.getSize());
                    b = ((MyByteArrayOutputStream)os).getBuf();
                    size = entry.getSize();
                } else {
                    size = urlConn.getContentLength();
                    os = new ByteArrayOutputStream();
                }
                byte[] buffer = new byte[8096];
                String msg = "Downloading " + path.substring(path.lastIndexOf(47) + 1);
                Main.showProgress(msg, 0);
                long completed = 0L;
                while ((read = is.read(buffer)) > 0) {
                    os.write(buffer, 0, read);
                    Main.showProgress(msg, (int)((completed += (long)read) * 100L / size));
                }
                is.close();
                if (b == null) {
                    b = os.toByteArray();
                }
                RamIO ramIO = new RamIO(b, mode);
                return ramIO;
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Main.showProgress(null, 0);
            }
            throw new FileNotFoundException(path);
        }
        if (path.toLowerCase().startsWith("jar://")) {
            InputStream is = Dosbox.class.getResourceAsStream(path = path.substring(6));
            if (is == null) {
                return null;
            }
            try {
                is.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return new JarIO(path, mode);
        }
        path = FileHelper.resolve_path(path);
        File f = new File(path);
        String m = "r";
        if ((mode & 2) != 0) {
            m = m + "w";
        }
        if ((mode & 4) != 0) {
            if (f.exists()) {
                f.delete();
            }
        } else if (!f.exists()) {
            throw new FileNotFoundException();
        }
        return new RandomIO(f, m);
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        public MyByteArrayOutputStream(int size) {
            super(size);
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }

    private static class JarIO
    implements FileIO {
        private String path;
        private int pos = 0;
        private int real_pos = 0;
        private int mode;
        private int len;
        private InputStream is;
        private final int cacheShift = 13;
        private final int cacheMask = 8191;
        private final int cachePageSize = 8192;
        private final LRUCache cache = new LRUCache(32);
        private byte[][] writeData = null;
        private int writePageCount;

        private InputStream getIS() {
            return (class$jdos$Dosbox == null ? (class$jdos$Dosbox = FileIOFactory.class$("jdos.Dosbox")) : class$jdos$Dosbox).getResourceAsStream(this.path);
        }

        public JarIO(String path, int mode) {
            this.path = path;
            this.mode = mode;
            this.is = this.getIS();
            try {
                this.len = this.is.available();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private byte[] fill(int offset) throws IOException {
            int r;
            int skip;
            if (this.real_pos == offset) {
                skip = 0;
            } else if (offset > this.real_pos) {
                skip = offset - this.real_pos;
            } else {
                this.is.close();
                this.is = this.getIS();
                skip = offset;
            }
            while (skip > 0) {
                skip = (int)((long)skip - this.is.skip(skip));
            }
            this.real_pos = offset;
            byte[] b = new byte[8192];
            int done = 0;
            for (int todo = 8192; todo > 0 && (r = this.is.read(b, done, todo)) >= 0; todo -= r) {
                done += r;
            }
            this.real_pos += done;
            return b;
        }

        private byte[] get(int offset) throws IOException {
            if (this.writeData != null && this.writeData[offset >> 13] != null) {
                return this.writeData[offset >> 13];
            }
            Integer i = new Integer(offset);
            byte[] b = (byte[])this.cache.get(i);
            if (b == null) {
                b = this.fill(offset);
                this.cache.put(i, b);
            }
            return b;
        }

        public int read() throws IOException {
            if (this.pos >= this.len) {
                return -1;
            }
            int offset = this.pos >> 13;
            int index = this.pos & 0x1FFF;
            byte[] b = this.get(offset);
            ++this.pos;
            return b[index] & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off + len >= this.len) {
                throw new IndexOutOfBoundsException();
            }
            if (this.pos >= this.len) {
                return -1;
            }
            if (this.pos + len > this.len) {
                len = this.len - this.pos;
            }
            int result = len;
            while (len > 0) {
                int offset = this.pos & 0xFFFFE000;
                int todo = len;
                int index = this.pos & 0x1FFF;
                if (todo > 8192 - index) {
                    todo = 8192 - index;
                }
                byte[] d = this.get(offset);
                System.arraycopy(d, index, b, off, todo);
                this.pos += todo;
                len -= todo;
                off += todo;
            }
            return result;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int skipBytes(int n) throws IOException {
            if (this.pos >= this.len) {
                return 0;
            }
            if (n + this.pos > this.len) {
                n = this.len - this.pos;
            }
            this.pos += n;
            return n;
        }

        public void write(int b) throws IOException {
            byte[] data;
            if ((this.mode & 2) == 0) {
                throw new IOException("Read Only");
            }
            int offset = this.pos >> 13;
            if (this.writeData == null) {
                this.writeData = new byte[(this.len >> 13) + 1][];
            }
            if ((data = this.writeData[offset >> 13]) == null) {
                data = this.get(offset);
                this.writeData[offset >> 13] = data;
                ++this.writePageCount;
            }
            int index = this.pos & 0x1FFF;
            ++this.pos;
            data[index] = (byte)b;
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if ((this.mode & 2) == 0) {
                throw new IOException("Read Only");
            }
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off + len >= this.len) {
                throw new IndexOutOfBoundsException();
            }
            if (this.pos >= this.len) {
                return;
            }
            if (this.pos + len > this.len) {
                len = this.len - this.pos;
            }
            while (len > 0) {
                byte[] data;
                int offset = this.pos & 0xFFFFE000;
                int todo = len;
                int index = this.pos & 0x1FFF;
                if (todo > 8192 - index) {
                    todo = 8192 - index;
                }
                if (this.writeData == null) {
                    this.writeData = new byte[(this.len >> 13) + 1][];
                    ++this.writePageCount;
                }
                if ((data = this.writeData[offset >> 13]) == null) {
                    data = this.get(offset);
                    this.writeData[offset >> 13] = data;
                }
                System.arraycopy(b, off, data, index, todo);
                this.pos += todo;
                len -= todo;
                off += todo;
            }
        }

        public void seek(long p) throws IOException {
            if (p == (long)this.pos) {
                return;
            }
            if (p > (long)this.len) {
                throw new IOException("EOF");
            }
            if (p < 0L) {
                throw new IOException("Invalid position: " + p);
            }
            this.pos = (int)p;
        }

        public long length() throws IOException {
            return this.len;
        }

        public void setLength(long newLength) throws IOException {
            throw new IOException("Not Supported");
        }

        public void close() throws IOException {
            this.is.close();
        }

        public long getFilePointer() throws IOException {
            return this.pos;
        }

        public long lastModified() {
            return 0L;
        }
    }

    private static class RamIO
    implements FileIO {
        private byte[] data;
        private int pos = 0;
        private int mode;

        public RamIO(byte[] data, int mode) {
            this.data = data;
            this.mode = mode;
        }

        public int read() throws IOException {
            if (this.pos >= this.data.length) {
                return -1;
            }
            return this.data[this.pos++];
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off + len >= this.data.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.pos >= this.data.length) {
                return -1;
            }
            if (this.pos + len > this.data.length) {
                len = this.data.length - this.pos;
            }
            System.arraycopy(this.data, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int skipBytes(int n) throws IOException {
            if (this.pos >= this.data.length) {
                return 0;
            }
            if (n + this.pos > this.data.length) {
                n = this.data.length - this.pos;
            }
            this.pos += n;
            return n;
        }

        public void write(int b) throws IOException {
            if ((this.mode & 2) == 0) {
                throw new IOException("Read Only");
            }
            if (this.pos >= this.data.length) {
                throw new IOException("EOF");
            }
            this.data[this.pos++] = (byte)(b & 0xFF);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if ((this.mode & 2) == 0) {
                throw new IOException("Read Only");
            }
            if (this.pos + len > this.data.length) {
                throw new IOException("EOF");
            }
            System.arraycopy(b, off, this.data, this.pos, len);
            this.pos += len;
        }

        public void seek(long p) throws IOException {
            if (p > (long)this.data.length) {
                throw new IOException("EOF");
            }
            if (p < 0L) {
                throw new IOException("Invalid position: " + p);
            }
            this.pos = (int)p;
        }

        public long length() throws IOException {
            return this.data.length;
        }

        public void setLength(long newLength) throws IOException {
            throw new IOException("Not Supported");
        }

        public void close() throws IOException {
        }

        public long getFilePointer() throws IOException {
            return this.pos;
        }

        public long lastModified() {
            return 0L;
        }
    }

    private static class RandomIO
    extends RandomAccessFile
    implements FileIO {
        File file;

        public RandomIO(File file, String mode) throws FileNotFoundException {
            super(file, mode);
            this.file = file;
        }

        public long lastModified() {
            return this.file.lastModified();
        }
    }
}

