/*
 * Decompiled with CFR 0.152.
 */
package jdos.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jdos.util.FileHelper;
import jdos.util.Progress;

public class UnZip {
    static final int BUFFER = 65536;

    public static boolean unzip(String fileName, String dir, Progress progress) {
        BufferedOutputStream dest = null;
        BufferedInputStream is = null;
        try {
            ZipEntry entry;
            ZipFile zipfile = new ZipFile(fileName);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            long totalSize = 0L;
            String root = null;
            while (e.hasMoreElements()) {
                entry = e.nextElement();
                totalSize += entry.getSize();
            }
            e = zipfile.entries();
            while (e.hasMoreElements()) {
                int count;
                entry = e.nextElement();
                System.out.println("Extracting: " + entry);
                progress.status("Extracting: " + entry);
                if (entry.isDirectory()) {
                    if (root == null) {
                        root = dir + "/" + entry.getName();
                    }
                    new File(dir + "/" + entry.getName()).mkdirs();
                    continue;
                }
                is = new BufferedInputStream(zipfile.getInputStream(entry));
                byte[] data = new byte[65536];
                File newFile = new File(dir + "/" + entry.getName());
                if (!newFile.getParentFile().exists()) {
                    if (root == null) {
                        root = newFile.getParentFile().getAbsolutePath();
                    }
                    newFile.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                dest = new BufferedOutputStream(fos, 65536);
                progress.initializeSpeedValue(totalSize);
                while ((count = is.read(data, 0, 65536)) != -1) {
                    dest.write(data, 0, count);
                    progress.incrementSpeedValue(count);
                    if (!progress.hasCancelled()) continue;
                    System.out.println("Cancelled Unzip operation");
                    dest.flush();
                    dest.close();
                    is.close();
                    FileHelper.deleteFile(new File(root));
                    return false;
                }
                dest.flush();
                dest.close();
                is.close();
                dest = null;
                is = null;
            }
            zipfile.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

